<?php
/*--------------------------------------------------------------------------------------------------
    ReaderService.php 2020-3-19
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2016 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\Attributes\SellingUnitQuantitiy\Database\Services;


use Gambio\Shop\Attributes\ProductModifiers\Database\ValueObjects\AttributeModifierIdentifier;
use Gambio\Shop\Attributes\SellingUnitQuantitiy\Database\Repository\RepositoryInterface;
use Gambio\Shop\Product\ValueObjects\ProductId;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\ModifierQuantityInterface;
use ProductDataInterface;

class ReaderService implements ReaderServiceInterface
{
    /**
     * @var RepositoryInterface
     */
    protected $repository;

    /**
     * ReaderService constructor.
     * @param RepositoryInterface $repository
     */
    public function __construct(RepositoryInterface $repository)
    {

        $this->repository = $repository;
    }

    /**
     * @inheritDoc
     */
    public function getQuantity(
        ProductId $productId,
        AttributeModifierIdentifier $modifierId,
        ProductDataInterface $product
    ): ?ModifierQuantityInterface {
        return $this->repository->getQuantity($productId, $modifierId, $product);
    }
}